/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakeAngularDim.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT MakeAngularDim(ILine *line1, ILine *line2)
{

//	Creates a AngularDim constraint between the two given lines

	START_METHOD("MakeAngularDim")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IAngularDim *pAngularDim = NULL;
	status = (GetCLASS(AngularDim))->CreateAngularDim(line1, line2, &pAngularDim);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint = NULL;

	status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint,pAngularDim), &pConstraint);
	CHECK_RETURN_STATUS(status)

	END_METHOD("MakeAngularDim")
}
